using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using gov.va.med.vbecs.BOL;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;
using ANTIBODYPARAMETER = gov.va.med.vbecs.Common.VbecsTables.AntibodyParameter;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgMaintainAntibodies
	/// </summary>
	public class DlgMaintainAntibodies : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpAntibodyList;
		private System.Windows.Forms.GroupBox grpSelectedAntibody;
		private System.Windows.Forms.ListView lvAntibodies;
		private System.Windows.Forms.ColumnHeader colAntibody;
		private System.Windows.Forms.ColumnHeader colCompatibility;
		private System.Windows.Forms.ColumnHeader colHigherLevel;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updCompatibility;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSave;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.Label lblCompatibility;
		private System.Windows.Forms.CheckBox cbHigherLevel;
		private System.Windows.Forms.Label lblPercentage;
		private System.Windows.Forms.TextBox txtName;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.CheckBox cbClinicallySignificant;
		private System.Windows.Forms.ColumnHeader colClinicallySignificant;
		private System.Windows.Forms.Label lblClinicallySignificant;
		private System.Windows.Forms.Label label1;
		private DataTable _antibodyList;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgMaintainAntibodies()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC023MaintainAntibodyTable;

			InitializeComponent();
			SetComponentProperties();			

			//Try locking them all
			if (!this.LockUseCase())
			{
				this.DialogResult = DialogResult.Abort;
				this.Close();
				return;
			}
			else
			{
				LoadAntibodyTypes(_antibodyList);
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgMaintainAntibodies));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.lvAntibodies = new System.Windows.Forms.ListView();
			this.colAntibody = new System.Windows.Forms.ColumnHeader();
			this.colClinicallySignificant = new System.Windows.Forms.ColumnHeader();
			this.colCompatibility = new System.Windows.Forms.ColumnHeader();
			this.colHigherLevel = new System.Windows.Forms.ColumnHeader();
			this.cbHigherLevel = new System.Windows.Forms.CheckBox();
			this.updCompatibility = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.txtName = new System.Windows.Forms.TextBox();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpAntibodyList = new System.Windows.Forms.GroupBox();
			this.grpSelectedAntibody = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.lblClinicallySignificant = new System.Windows.Forms.Label();
			this.cbClinicallySignificant = new System.Windows.Forms.CheckBox();
			this.btnSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.lblPercentage = new System.Windows.Forms.Label();
			this.lblCompatibility = new System.Windows.Forms.Label();
			this.lblName = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.updCompatibility)).BeginInit();
			this.grpImage.SuspendLayout();
			this.grpAntibodyList.SuspendLayout();
			this.grpSelectedAntibody.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(508, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Maintain Antibodies";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 421);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(352, 408);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(430, 408);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// lvAntibodies
			// 
			this.lvAntibodies.AccessibleDescription = "Antibody List";
			this.lvAntibodies.AccessibleName = "Antibody List";
			this.lvAntibodies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAntibodies.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						   this.colAntibody,
																						   this.colClinicallySignificant,
																						   this.colCompatibility,
																						   this.colHigherLevel});
			this.lvAntibodies.FullRowSelect = true;
			this.lvAntibodies.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvAntibodies.HideSelection = false;
			this.lvAntibodies.Location = new System.Drawing.Point(8, 16);
			this.lvAntibodies.MultiSelect = false;
			this.lvAntibodies.Name = "lvAntibodies";
			this.lvAntibodies.Size = new System.Drawing.Size(428, 228);
			this.lvAntibodies.TabIndex = 0;
			this.lvAntibodies.View = System.Windows.Forms.View.Details;
			this.lvAntibodies.SelectedIndexChanged += new System.EventHandler(this.lvAntibodies_SelectedIndexChanged);
			// 
			// colAntibody
			// 
			this.colAntibody.Text = "Antibody Name";
			this.colAntibody.Width = 94;
			// 
			// colClinicallySignificant
			// 
			this.colClinicallySignificant.Text = "Clinically Significant?";
			this.colClinicallySignificant.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.colClinicallySignificant.Width = 115;
			// 
			// colCompatibility
			// 
			this.colCompatibility.Text = "AG Neg %";
			this.colCompatibility.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.colCompatibility.Width = 90;
			// 
			// colHigherLevel
			// 
			this.colHigherLevel.Text = "Higher-Level Override?";
			this.colHigherLevel.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.colHigherLevel.Width = 125;
			// 
			// cbHigherLevel
			// 
			this.cbHigherLevel.AccessibleDescription = "Require high level user to override antigen negative requirement";
			this.cbHigherLevel.AccessibleName = "Require high level user to override antigen negative requirement";
			this.cbHigherLevel.CheckAlign = System.Drawing.ContentAlignment.TopRight;
			this.cbHigherLevel.Enabled = false;
			this.cbHigherLevel.Location = new System.Drawing.Point(8, 88);
			this.cbHigherLevel.Name = "cbHigherLevel";
			this.cbHigherLevel.Size = new System.Drawing.Size(230, 28);
			this.cbHigherLevel.TabIndex = 7;
			this.cbHigherLevel.Text = "&Require high-level user to override antigen negative requirement?";
			this.cbHigherLevel.Enter += new System.EventHandler(this.cbHigherLevel_Enter);
			this.cbHigherLevel.CheckedChanged += new System.EventHandler(this.cbHigherLevel_CheckedChanged);
			// 
			// updCompatibility
			// 
			this.updCompatibility.AccessibleDescription = "Antigen Negative Compatibility Percentage";
			this.updCompatibility.AccessibleName = "Antigen Negative Compatibility Percentage";
			this.updCompatibility.Enabled = false;
			this.updCompatibility.Location = new System.Drawing.Point(224, 64);
			this.updCompatibility.Name = "updCompatibility";
			this.updCompatibility.Size = new System.Drawing.Size(56, 20);
			this.updCompatibility.TabIndex = 5;
			this.updCompatibility.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updCompatibility.Value = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.updCompatibility.Enter += new System.EventHandler(this.updCompatibility_Enter);
			this.updCompatibility.TextChanged += new System.EventHandler(this.updCompatibility_ValueChanged);
			this.updCompatibility.Leave += new System.EventHandler(this.updCompatibility_Leave);
			this.updCompatibility.ValueChanged += new System.EventHandler(this.updCompatibility_ValueChanged);
			// 
			// txtName
			// 
			this.txtName.AccessibleDescription = "Antibody Name";
			this.txtName.AccessibleName = "Antibody Name";
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Location = new System.Drawing.Point(224, 16);
			this.txtName.Name = "txtName";
			this.txtName.ReadOnly = true;
			this.txtName.Size = new System.Drawing.Size(208, 20);
			this.txtName.TabIndex = 1;
			this.txtName.Text = "";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 372);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpAntibodyList
			// 
			this.grpAntibodyList.AccessibleDescription = "Antibody List";
			this.grpAntibodyList.AccessibleName = "Antibody List";
			this.grpAntibodyList.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAntibodyList.Controls.Add(this.lvAntibodies);
			this.grpAntibodyList.Location = new System.Drawing.Point(60, 32);
			this.grpAntibodyList.Name = "grpAntibodyList";
			this.grpAntibodyList.Size = new System.Drawing.Size(444, 252);
			this.grpAntibodyList.TabIndex = 0;
			this.grpAntibodyList.TabStop = false;
			this.grpAntibodyList.Text = "Antibody List";
			// 
			// grpSelectedAntibody
			// 
			this.grpSelectedAntibody.AccessibleDescription = "Selected Antibody";
			this.grpSelectedAntibody.AccessibleName = "Selected Antibody";
			this.grpSelectedAntibody.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSelectedAntibody.Controls.Add(this.label1);
			this.grpSelectedAntibody.Controls.Add(this.lblClinicallySignificant);
			this.grpSelectedAntibody.Controls.Add(this.cbClinicallySignificant);
			this.grpSelectedAntibody.Controls.Add(this.btnSave);
			this.grpSelectedAntibody.Controls.Add(this.txtName);
			this.grpSelectedAntibody.Controls.Add(this.lblPercentage);
			this.grpSelectedAntibody.Controls.Add(this.updCompatibility);
			this.grpSelectedAntibody.Controls.Add(this.cbHigherLevel);
			this.grpSelectedAntibody.Controls.Add(this.lblCompatibility);
			this.grpSelectedAntibody.Controls.Add(this.lblName);
			this.grpSelectedAntibody.Location = new System.Drawing.Point(60, 284);
			this.grpSelectedAntibody.Name = "grpSelectedAntibody";
			this.grpSelectedAntibody.Size = new System.Drawing.Size(444, 120);
			this.grpSelectedAntibody.TabIndex = 1;
			this.grpSelectedAntibody.TabStop = false;
			this.grpSelectedAntibody.Text = "Selected Antibody";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 88);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(208, 28);
			this.label1.TabIndex = 9;
			this.label1.Text = "&Require high-level user to override antigen negative requirement?";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblClinicallySignificant
			// 
			this.lblClinicallySignificant.Location = new System.Drawing.Point(8, 40);
			this.lblClinicallySignificant.Name = "lblClinicallySignificant";
			this.lblClinicallySignificant.Size = new System.Drawing.Size(184, 20);
			this.lblClinicallySignificant.TabIndex = 3;
			this.lblClinicallySignificant.Text = "Clinically Significant?";
			this.lblClinicallySignificant.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbClinicallySignificant
			// 
			this.cbClinicallySignificant.AccessibleDescription = "Clinically Significant";
			this.cbClinicallySignificant.AccessibleName = "Clinically Significant";
			this.cbClinicallySignificant.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbClinicallySignificant.Enabled = false;
			this.cbClinicallySignificant.Location = new System.Drawing.Point(8, 40);
			this.cbClinicallySignificant.Name = "cbClinicallySignificant";
			this.cbClinicallySignificant.Size = new System.Drawing.Size(230, 20);
			this.cbClinicallySignificant.TabIndex = 2;
			this.cbClinicallySignificant.Text = "Clinically Significant?";
			// 
			// btnSave
			// 
			this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSave.Image = ((System.Drawing.Image)(resources.GetObject("btnSave.Image")));
			this.btnSave.Location = new System.Drawing.Point(360, 88);
			this.btnSave.Name = "btnSave";
			this.btnSave.Size = new System.Drawing.Size(75, 23);
			this.btnSave.TabIndex = 8;
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// lblPercentage
			// 
			this.lblPercentage.Location = new System.Drawing.Point(280, 64);
			this.lblPercentage.Name = "lblPercentage";
			this.lblPercentage.Size = new System.Drawing.Size(16, 20);
			this.lblPercentage.TabIndex = 6;
			this.lblPercentage.Text = "%";
			this.lblPercentage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblCompatibility
			// 
			this.lblCompatibility.Location = new System.Drawing.Point(8, 64);
			this.lblCompatibility.Name = "lblCompatibility";
			this.lblCompatibility.Size = new System.Drawing.Size(224, 20);
			this.lblCompatibility.TabIndex = 4;
			this.lblCompatibility.Text = "Antigen Negative Compatibility Percentage";
			this.lblCompatibility.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 16);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(196, 20);
			this.lblName.TabIndex = 0;
			this.lblName.Text = "Antibody Name";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgMaintainAntibodies
			// 
			this.AcceptButton = this.btnSave;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(508, 437);
			this.Controls.Add(this.grpSelectedAntibody);
			this.Controls.Add(this.grpAntibodyList);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Antibodies.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(516, 464);
			this.Name = "DlgMaintainAntibodies";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Maintain Antibodies";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgMaintainAntibodies_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpAntibodyList, 0);
			this.Controls.SetChildIndex(this.grpSelectedAntibody, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			((System.ComponentModel.ISupportInitialize)(this.updCompatibility)).EndInit();
			this.grpImage.ResumeLayout(false);
			this.grpAntibodyList.ResumeLayout(false);
			this.grpSelectedAntibody.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		private void LoadAntibodyTypes(DataTable _antibodyTypes)
		{
			string higherLevelOverrideIndic;
			lvAntibodies.Items.Clear();

			foreach(DataRow _antibodyType in _antibodyTypes.Rows)
			{
				if ((int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 1 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 4 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 64 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 49 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 43 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 32 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 37 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 36 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 46 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 23 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 65 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 66 ||
					(int)_antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeId] == 11)
					continue;

				ListViewItem lviAntibodyType = new ListViewItem();
				lviAntibodyType.UseItemStyleForSubItems = false;
				lviAntibodyType.Text = _antibodyType[Common.VbecsTables.AntibodyType.AntibodyTypeName].ToString();
				//
				//Clinically Significant
				if (_antibodyType.IsNull(Common.VbecsTables.AntibodyType.ClinicallySignificantIndicator))
				{
					lviAntibodyType.SubItems.Add("Unknown");
				}
				else
				{
					if (Convert.ToBoolean(_antibodyType[Common.VbecsTables.AntibodyType.ClinicallySignificantIndicator]))
					{
						lviAntibodyType.SubItems.Add("Yes");
					}
					else
					{
						lviAntibodyType.SubItems.Add("No");
					}
				}
				//AG Neg %
				if (_antibodyType.IsNull(Common.VbecsTables.AntibodyParameter.CompatibilityPercentage))
				{
					lviAntibodyType.SubItems.Add("N/A",lvAntibodies.ForeColor,Color.FromKnownColor(KnownColor.Control),lvAntibodies.Font);
				}
				else
				{
					lviAntibodyType.SubItems.Add(_antibodyType[Common.VbecsTables.AntibodyParameter.CompatibilityPercentage].ToString(),lvAntibodies.ForeColor,lvAntibodies.BackColor,lvAntibodies.Font);
				}

				//Higher Level Override
				if (_antibodyType.IsNull(Common.VbecsTables.AntibodyParameter.HigherLevelOverrideIndicator))
				{
					higherLevelOverrideIndic = "N/A";
				}
				else
				{
					if (Convert.ToBoolean(_antibodyType[Common.VbecsTables.AntibodyParameter.HigherLevelOverrideIndicator]))
					{
						higherLevelOverrideIndic = "Yes";
					}
					else
					{
						higherLevelOverrideIndic = "No";
					}
				}
				if (Convert.ToBoolean(_antibodyType[Common.VbecsTables.AntibodyParameter.CanChangeIndicator]))
				{
					lviAntibodyType.SubItems.Add(higherLevelOverrideIndic,lvAntibodies.ForeColor,lvAntibodies.BackColor,lvAntibodies.Font);
				}
				else
				{
					lviAntibodyType.SubItems.Add(higherLevelOverrideIndic,lvAntibodies.ForeColor,Color.FromKnownColor(KnownColor.Control),lvAntibodies.Font);
				}
				//
				lviAntibodyType.Tag = _antibodyType;
				lvAntibodies.Items.Add(lviAntibodyType);
			}
			controls.VbecsFunction.SetColumnWidths(this.lvAntibodies);
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Maintain Antibodies";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC023.DlgMaintainAntibodies());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.btnSave.Text = "&Update";
			this.btnSave.EnabledButton = false;

			_antibodyList = BOL.AntibodyType.GetAntibodiesWithoutAntigens();	
		}

		/// <summary>
		/// Saves changes to the single item on the listview
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			if (lvAntibodies.SelectedItems.Count > 0)
			{
				ListViewItem _lvItem = lvAntibodies.SelectedItems[0];
				DataRow _lvDataRow = (DataRow)_lvItem.Tag;

				// CR3054 start: Only update compatibility if it has a non-null value.
				if (_lvDataRow[Common.VbecsTables.AntibodyParameter.CompatibilityPercentage] != System.DBNull.Value)
				{
					_lvItem.SubItems[2].Text = updCompatibility.Value.ToString();
					_lvDataRow[Common.VbecsTables.AntibodyParameter.CompatibilityPercentage] = updCompatibility.Value;
				}
				// CR3054 end

				//
				if (cbHigherLevel.Checked)
				{
					_lvItem.SubItems[3].Text = "Yes";
					_lvDataRow[Common.VbecsTables.AntibodyParameter.HigherLevelOverrideIndicator] = true;
				}
				else
				{
					_lvItem.SubItems[3].Text = "No";
					_lvDataRow[Common.VbecsTables.AntibodyParameter.HigherLevelOverrideIndicator] = false;
				}

				btnOK.EnabledButton = true;
				updCompatibility.Value = 0;
				updCompatibility.Enabled = false;
				cbHigherLevel.Checked = false;
				cbHigherLevel.Enabled = false;
				txtName.Text = String.Empty;
				btnSave.EnabledButton = false;
				this.lvAntibodies.SelectedItems.Clear();
				this.IsDirty=true;
			}
		}

		private void lvAntibodies_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (lvAntibodies.SelectedItems != null && lvAntibodies.SelectedItems.Count != 0)
			{
				ListViewItem _lvItem = lvAntibodies.SelectedItems[0];
				DataRow _lvDataRow = (DataRow)_lvItem.Tag;

				BOL.AntibodyParameter tmpAP = new AntibodyParameter((int)_lvDataRow[Common.VbecsTables.AntibodyParameter.AntibodyTypeId]);
							
				txtName.Text = _lvDataRow[Common.VbecsTables.AntibodyType.AntibodyTypeName].ToString();
				//
				if (_lvDataRow.IsNull(Common.VbecsTables.AntibodyType.ClinicallySignificantIndicator))
				{
					cbClinicallySignificant.Checked = false;
				}
				else
				{
					if (Convert.ToBoolean(_lvDataRow[Common.VbecsTables.AntibodyType.ClinicallySignificantIndicator]))
					{
						cbClinicallySignificant.Checked = true;
					}
					else
					{
						cbClinicallySignificant.Checked = false;
					}
				}
				//
				if (_lvDataRow.IsNull(Common.VbecsTables.AntibodyParameter.CompatibilityPercentage))
				{
					updCompatibility.Value = 0;
					updCompatibility.Enabled = false;
				}
				else
				{
					updCompatibility.Value = Convert.ToByte(_lvDataRow[Common.VbecsTables.AntibodyParameter.CompatibilityPercentage]);
					updCompatibility.Enabled = true;
				}
				//
				cbHigherLevel.Enabled = (Convert.ToBoolean(_lvDataRow[Common.VbecsTables.AntibodyParameter.CanChangeIndicator]));
				//
				if (_lvDataRow.IsNull(Common.VbecsTables.AntibodyParameter.HigherLevelOverrideIndicator))
				{
					cbHigherLevel.Checked = false;
				}
				else
				{
					if (Convert.ToBoolean(_lvDataRow[Common.VbecsTables.AntibodyParameter.HigherLevelOverrideIndicator]))
					{
						cbHigherLevel.Checked = true;
					}
					else
					{
						cbHigherLevel.Checked = false;
					}
				}
			}
			btnSave.EnabledButton = false;
		}

		private void updCompatibility_Enter(object sender, System.EventArgs e)
		{
			//REMOVED - This would not allow non-mouse user to edit check-box, a 508 non-compliance
			//keeps focus on the listview to make sure that the user can see which row is being updated
			//btnSave.EnabledButton = true;
			//lvAntibodies.Focus();
		}

		private void cbHigherLevel_Enter(object sender, System.EventArgs e)
		{
			//REMOVED - This would not allow non-mouse user to edit check-box, a 508 non-compliance
			//keeps focus on the listview to make sure that the user can see which row is being updated
			//btnSave.EnabledButton = true;
			//lvAntibodies.Focus();
		}

		/// <summary>
		/// Saves changes to the database
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("antibody definition"));
			if (_saveResult == DialogResult.Yes)
			{
				try
				{
					if (BOL.AntibodyType.SaveAntibodyTypes(_antibodyList, Common.UpdateFunction.UC023DlgMaintainAntibodies) == false)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Antibody"));
						return;
					}
					//Successful save, no longer dirty, close form.
					this.IsDirty=false;
					this.Close();
				}
				catch (RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}		
			}
		}

		private void cbHigherLevel_CheckedChanged(object sender, System.EventArgs e)
		{
			this.btnSave.EnabledButton = (this.errError.GetError(lblPercentage).Length==0);
			this.IsDirty=true;
		}

		private void updCompatibility_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.updCompatibility.Value = this.updCompatibility.Value;
				this.btnSave.EnabledButton = true;
				this.errError.SetVbecsError(lblPercentage, string.Empty); // **** 508 Compliance ***
				this.IsDirty=true;
			}
			catch(FormatException)
			{
				this.btnSave.EnabledButton = false;
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void updCompatibility_Leave(object sender, System.EventArgs e)
		{
			try
			{
				this.updCompatibility.Value = this.updCompatibility.Value;
				this.btnSave.EnabledButton = true;
				this.errError.SetVbecsError(lblPercentage, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this.errError.SetVbecsError(lblPercentage, err.Message); // **** 508 Compliance ***
				this.btnSave.EnabledButton = false;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgMaintainAntibodies_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnSave.EnabledButton == false)
			{
				textToSpeak = this.btnSave.GetToolTip();
			}
			else if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}

	}
}

